libname q 'c:/SASCodeforBook/SASDataSets';
data tryone; set q.humandevelopment; 

	/*This syntax makes the standard HDIRank Runs Replicating the Chapter's Table 7.3*/

	/*These runs weight the country by the square root of its population*/
	/*These runs use the ten-point corrupt scale except for the nesting by the four-
		category coruptyp typology*/

Sqrtpop = sqrt(populat);

	/*this code makes the corruption typology*/
coruptyp = .;
	if 1 le corrupt < 3 then coruptyp = 4;
	if 3 le corrupt le 3.3 then coruptyp = 3;
	if 3.4 le corrupt le 5 then coruptyp = 2;
	if 5.01 le corrupt le 11 then coruptyp = 1;

	/*this code makes the freedom typology*/
Fretyp99 = . ;
	if free399 = 'F' then fretyp99 = 1;
	if free399 = 'P' or free399 = 'PF' then fretyp99 = 2;
	if free399 = 'NF' then fretyp99 = 3; 

	/*The following code can be ignored, it presents my method of simulating the effect of class statement
	on missing data.  s stands for signal. This code will produce a flat file of 138 countries*/
sregion = .;
	if region = '01e' or region = '01m' or region = '01n' or region = '01s' or 
	region = '01w' then sregion = 1;
	if region = '02' then sregion = 1;
	if region = '03c' or region = '03ca' or region = '03sa' or region = '04e' or
	region = '04sc' or region = '04se' or region = '04w' then sregion = 1;
	if region = '05e' or region = '05n' or region = '05s' or region = '05w' then sregion = 1;
	if region = '06' then sregion = 1; 

sculture = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	or culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then sculture = 1;

sfretyp9 = .;
	if fretyp99 ne . then sfretyp9 = 1;

sdebt = .;
	if debt ne . then sdebt = 1;

sconflic = .;
	if conflict ne . then sconflic = 1;

scorupt = .;
	if coruptyp ne . then scorupt = 1;
    
sslave = .;
	if slave98 ne . then sslave = 1;
 
fulslave = .;
	if (slavery  ne . or slavery ne 0) then fulslave = 1;

shdirank = .;
	if hdirank ne . then shdirank = 1;

		/*signal=1 will eliminate countries that have some missing data*/

signal = scorupt * sconflic * sdebt * sfretyp9 * sculture * sregion *sslave * shdirank;
run;

	   /* This code creates the working dataset explore that has 138 cases.  The revhdi
	variable reverses the ranking of the human development scale so that higher scores indicate
	poorer human development*/
data explore; set tryone;
	if signal = 1;  *there will be 138 cases;
	revhdi = 183-hdirank;
run;

data explore; set explore;
	/* This code dichotomizes the cultures as similar to the west (LikeWest = 1) or not (0)*/

LikeWest = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	then LikeWest = 0;
	If culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then likewest = 1;

		*These codes dichotomize the instrumental freedom prerequisites;
lodebt = 1;
	if debt = 2 then lodebt = 0;
	if debt = . then lodebt = .;

dichofre = 0;
	if fretyp99 = 1 then dichofre = 1;
	if fretyp99 = . then dichofre = .;

integrit = 0;
	if coruptyp = 1 then integrit =1;
	if coruptyp = . then integrit = .;

emancip = . ;
	if slavery = 3 or slavery = 4 then emancip = 0;
	if slavery = 1 or slavery = 2 then emancip = 1;

nochaos = 1;
	if conflict = . then nochaos = .;
	if conflict > 0 then nochaos = 0;

	/* This code creates a summary index of instrumental freedoms*/

instfree = dichofre + integrit + emancip +lodebt + nochaos;

run;

	/* Code for Table 7.3, Explanatory Models of Human Development Rank*/
	/* s is an appreviation for solution*/
	/* the parms/nobound statement implements a likelihood ratio test of the between-region
		variance and changes the bounds on the confidence intervals for the variance components*/
	/* Figure 7.4 depicts some of these random effects estimates*/

Title '7.3 Model 1, Mixed Weighted no nesting, HDIRank, Intercepts Only';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 Debt conflict coruptyp;
	model hdirank =  /solution ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;
run;

Title ' 7.3 Model 2, Mixed weighted no nesting,  HDIRank, Full Descriptive Model';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	parms/nobound;
	*Figure 7.4 depicts the random effects estimates;
run;

Title ' 7.3 Model 3, Mixed weighted, nesting by civilizations, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank =  culture slave98 fretyp99 debt conflict corrupt /s ;
	random region(culture)/solution;
	weight sqrtpop;
	parms/nobound;
run;

Title ' 7.3 Model 4, Mixed weighted, nesting by slavery,  HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
	random region(slave98)/solution;
	weight sqrtpop;
	parms/nobound;
	*Figure 7.4 depicts these random effects estimates;
estimate 'mean'		   intercept 1 | region (slave98)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;	
estimate 'region 01e'  intercept 1 | region (slave98)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01m'  intercept 1 | region (slave98)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01n'  intercept 1 | region (slave98)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01s'  intercept 1 | region (slave98)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01w'  intercept 1 | region (slave98)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 02'   intercept 1 | region (slave98)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03c'  intercept 1 | region (slave98)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03ca' intercept 1 | region (slave98)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03sa' intercept 1 | region (slave98)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'region 04e'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'region 04sc' intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'region 04se' intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'region 04w'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'region 05e'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'region 05n'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'region 05s'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'region 05w'  intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'region 06'   intercept 1 | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;


estimate 'mean'			 | region (slave98)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'Uregion 01e'   | region (slave98)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01m'   | region (slave98)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01n'   | region (slave98)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01s'   | region (slave98)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01w'   | region (slave98)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 02'    | region (slave98)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03c'   | region (slave98)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03ca'  | region (slave98)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03sa'  | region (slave98)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 04e'   | region (slave98)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'Uregion 04sc'  | region (slave98)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'Uregion 04se'  | region (slave98)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'Uregion 04w'   | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'Uregion 05e'   | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'Uregion 05n'   | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'Uregion 05s'   | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'Uregion 05w'   | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'Uregion 06'    | region (slave98)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;

run;


Title '7.3 Model 5, Mixed weighted, nesting by 3-category political freedom index, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
	random region(fretyp99)/solution;
	weight sqrtpop;
	parms/nobound;
run;


Title '7.3 Model 6, Mixed weighted, nesting by 2-category political freedom index, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt/s ;
	random region(dichofre)/solution;
	weight sqrtpop;
	parms/nobound;
	*Figure 7.4 depicts the random effects estimates;
estimate 'mean'		   intercept 1 | region (dichofre)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;	
estimate 'region 01e'  intercept 1 | region (dichofre)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01m'  intercept 1 | region (dichofre)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01n'  intercept 1 | region (dichofre)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01s'  intercept 1 | region (dichofre)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01w'  intercept 1 | region (dichofre)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 02'   intercept 1 | region (dichofre)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03c'  intercept 1 | region (dichofre)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03ca' intercept 1 | region (dichofre)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03sa' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'region 04e'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'region 04sc' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'region 04se' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'region 04w'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'region 05e'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'region 05n'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'region 05s'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'region 05w'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'region 06'   intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;

estimate 'mean'			 | region (dichofre)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'Uregion 01e'   | region (dichofre)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01m'   | region (dichofre)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01n'   | region (dichofre)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01s'   | region (dichofre)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01w'   | region (dichofre)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 02'    | region (dichofre)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03c'   | region (dichofre)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03ca'  | region (dichofre)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03sa'  | region (dichofre)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 04e'   | region (dichofre)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'Uregion 04sc'  | region (dichofre)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'Uregion 04se'  | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'Uregion 04w'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'Uregion 05e'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'Uregion 05n'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'Uregion 05s'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'Uregion 05w'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'Uregion 06'    | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
run;

Title '7.3 Model 7, Mixed weighted, nesting by debt, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
	random region(debt)/solution;
	weight sqrtpop;
	parms/nobound;
run;

Title '7.3 Model 8, Mixed weighted,nesting by conflict, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt/s ;
	random region(conflict)/solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '7.3 Model 9, Mixed weighted, nesting by covariate corruption typology, HDIRank';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict coruptyp/s ;
	random region(coruptyp)/solution;
	lsmeans coruptyp/pdiff;
	weight sqrtpop;
	parms/nobound;  
run;

	/*Footnotes to Table 7.3*/

Title '7.3 Model 4a, Table footnote a, Mixed weighted,HDIRank, dichotomized slavery is covariate';
proc mixed covtest ratio  cl=wald ;
	class  region culture emancip fretyp99 debt conflict coruptyp slave98;
	model hdirank = culture emancip fretyp99 debt conflict corrupt /s ;
	random region(slave98)/solution;
	weight sqrtpop;
	parms/nobound;  
run;


	/*The following are referenced to Table 7.3, footnote b */

Title '7.3 Model 2b full descriptive model with dichotomized freedom, Mixed weighted no nesting, HDIRank, Full Model, 
	freedom dichotomized  First table footnote b';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	parms/nobound;  
run;


Title ' 7.3 Model 4b, Mixed weighted, nesting by full slavery, HDIRank, Full Model,
	dichotomized freedom';

proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region(slave98) /solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '7.2 Model 5b, Mixed weighted  nesting, HDIRank, Full Model, 
	freedom covariate dichotomized';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre fretyp99 debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region (dichofre)/solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '7.3 Model 6b, Mixed weighted nesting, HDIRank, Full Model, 
	freedom covariate dichotomized';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region (dichofre)/solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '7.3 Model 7b, Mixed weighted, nesting by debt, HDIRank, dichotomized freedom';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region(debt)/solution;
	weight sqrtpop;
	parms/nobound;
run;

Title '7.3 Model 8b, Mixed weighted,nesting by conflict, HDIRank, dichomized freedom';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt/s ;
	random region(conflict)/solution;
	weight sqrtpop;
	parms/nobound;  
run;

	/* The code for Table 7.3 is now complete*/
	/* The syntax in this file is copyright by Robert B. Smith  2011.*/







































		





































